import json

# Load the generated_captions and val data
generated_captions_path = 'YOUR_PATH/generated_captions_hae_copy.jsonl'
val_path = 'YOUR_PATH/val_copy.jsonl'

# Load the generated captions data
with open(generated_captions_path, 'r') as file:
    generated_captions_data = [json.loads(line) for line in file]

# Load the val data
with open(val_path, 'r') as file:
    val_data = [json.loads(line) for line in file]

# Initialize a list to store the combined data
combined_data = []

# Index to track which caption we are at in generated_captions
caption_index = 0

# Iterate through val data and match it with generated captions
for item in val_data:
    # Get the images (paths) from the current item
    images = item["images"]
    num_images = len(images)
    
    # Get the next num_images captions from generated_captions
    captions = []
    for i in range(num_images):
        if caption_index < len(generated_captions_data):
            captions.append(generated_captions_data[caption_index]['generated_caption'][0])  # Each item has one caption
            caption_index += 1

    # Create a new combined item with images and captions
    combined_item = {
        "images": images,
        "captions": captions
    }

    combined_data.append(combined_item)

# Save the combined data to a new JSONL file
output_path = 'YOUR_PATH/combined_outputhae.jsonl'
with open(output_path, 'w') as output_file:
    for entry in combined_data:
        output_file.write(json.dumps(entry) + '\n')

print(f"Combined data saved to {output_path}")
